/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.io.FileHandler;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class ExternalWaypointFinder {
    private final List<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
    private boolean didSearch = false;

    public boolean hasExternalWaypoints() {
        if (!this.didSearch) {
            try {
                this.findXaeroWaypointsForWorld();
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error finding external waypoints.", (Throwable)e);
            }
        }
        return !this.getXaeroWaypoints().isEmpty();
    }

    public List<ClientWaypointImpl> getXaeroWaypoints() {
        return this.xaeroWaypoints.stream().filter(waypoint -> !this.waypointExist((Waypoint)waypoint)).toList();
    }

    private boolean waypointExist(Waypoint waypoint) {
        for (ClientWaypointImpl wp : WaypointStore.getInstance().getAll()) {
            if (wp.getX() != waypoint.getX() || wp.getZ() != waypoint.getZ() || wp.getY() != waypoint.getY() || !wp.getGroupId().equalsIgnoreCase(waypoint.getGroupId()) || !wp.getPrimaryDimension().equalsIgnoreCase(waypoint.getPrimaryDimension())) continue;
            return true;
        }
        return false;
    }

    private void findXaeroWaypointsForWorld() {
        File[] directories;
        this.didSearch = true;
        class_310 mc = class_310.method_1551();
        Object worldDirectory = mc.method_47392() || class_310.method_1551().method_1558() == null || class_310.method_1551().method_1558().method_2994() ? mc.method_1576().field_23784.method_27005() : "Multiplayer_" + class_310.method_1551().method_1558().field_3761;
        File xaeroMiniMapDir = new File(FileHandler.getMinecraftDirectory(), "xaero/minimap/" + (String)worldDirectory);
        if (xaeroMiniMapDir.exists() && (directories = xaeroMiniMapDir.listFiles(File::isDirectory)) != null) {
            for (File wpDir : directories) {
                if (!wpDir.isDirectory()) continue;
                File[] files = wpDir.listFiles(file -> file.getName().endsWith(".txt"));
                String dim = this.getDimensionFromDirectoryName(wpDir.getName());
                if (files == null) continue;
                for (File waypointFile : files) {
                    List<ClientWaypointImpl> waypoints = this.buildWaypoints(dim, waypointFile);
                    if (waypoints == null) continue;
                    this.xaeroWaypoints.addAll(waypoints);
                }
            }
        }
    }

    private List<ClientWaypointImpl> buildWaypoints(String dimension, File waypoints) {
        ArrayList<ClientWaypointImpl> xaeroWaypoints = new ArrayList<ClientWaypointImpl>();
        try {
            return Files.readAllLines(waypoints.toPath()).stream().skip(3L).map(wp -> this.parsed((String)wp, dimension)).filter(waypoint -> !this.waypointExist((Waypoint)waypoint)).toList();
        }
        catch (IOException e) {
            Journeymap.getLogger().error("Error building importable waypoints.", (Throwable)e);
            return xaeroWaypoints;
        }
    }

    private ClientWaypointImpl parsed(String wp, String dimension) {
        String[] parsed = wp.split(":");
        String name = parsed[1].replace("gui.xaero_", "");
        int x = Integer.parseInt(parsed[3]);
        int y = Integer.parseInt(parsed[4].replace("~", "63"));
        int z = Integer.parseInt(parsed[5]);
        class_2338 pos = new class_2338(x, y, z);
        if (name.equalsIgnoreCase("deathpoint")) {
            return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, true, true);
        }
        return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", pos, name, dimension, false, true);
    }

    private String getDimensionFromDirectoryName(String name) {
        String value;
        return switch (value = name.split("%")[1]) {
            case "-1" -> "minecraft:the_nether";
            case "1" -> "minecraft:the_end";
            case "0" -> "minecraft:overworld";
            default -> value.replace("$", ":");
        };
    }
}

