/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBoolean;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;

public enum InfoToggle implements IConfigInteger,
IHotkeyTogglable
{
    FPS("infoFPS", false, ""),
    MEMORY_USAGE("infoMemoryUsage", false, ""),
    TIME_REAL("infoTimeIRL", true, ""),
    TIME_WORLD("infoTimeWorld", false, ""),
    TIME_WORLD_FORMATTED("infoWorldTimeFormatted", false, ""),
    COORDINATES("infoCoordinates", true, ""),
    COORDINATES_SCALED("infoCoordinatesScaled", false, ""),
    BLOCK_POS("infoBlockPosition", false, ""),
    CHUNK_POS("infoChunkPosition", false, ""),
    BLOCK_IN_CHUNK("infoBlockInChunk", false, ""),
    DIMENSION("infoDimensionId", false, ""),
    FACING("infoFacing", true, ""),
    ROTATION_YAW("infoRotationYaw", false, ""),
    ROTATION_PITCH("infoRotationPitch", false, ""),
    BLOCK_BREAK_SPEED("infoBlockBreakSpeed", false, ""),
    PLAYER_EXPERIENCE("infoPlayerExperience", false, ""),
    SPEED("infoSpeed", false, ""),
    SPEED_AXIS("infoSpeedAxis", false, ""),
    SPEED_HV("infoSpeedHV", false, ""),
    SPRINTING("infoSprinting", false, ""),
    SERVER_TPS("infoServerTPS", false, ""),
    SERVUX("infoServux", false, true, ""),
    PING("infoPing", false, ""),
    WEATHER("infoWeather", false, true, ""),
    TIME_TOTAL_MODULO("infoTimeTotalModulo", false, ""),
    TIME_DAY_MODULO("infoTimeDayModulo", false, ""),
    MOB_CAPS("infoMobCaps", false, true, ""),
    PARTICLE_COUNT("infoParticleCount", false, ""),
    DIFFICULTY("infoDifficulty", false, ""),
    ENTITIES("infoEntities", false, ""),
    ENTITIES_CLIENT_WORLD("infoEntitiesClientWorld", false, ""),
    TILE_ENTITIES("infoTileEntities", false, ""),
    LIGHT_LEVEL("infoLightLevel", false, ""),
    BIOME("infoBiome", false, ""),
    BIOME_REG_NAME("infoBiomeRegistryName", false, ""),
    DISTANCE("infoDistance", false, ""),
    LOADED_CHUNKS_COUNT("infoLoadedChunksCount", false, ""),
    CHUNK_SECTIONS("infoChunkSections", false, ""),
    CHUNK_SECTIONS_FULL("infoChunkSectionsLine", false, ""),
    CHUNK_UPDATES("infoChunkUpdates", false, ""),
    REGION_FILE("infoRegionFile", false, ""),
    SLIME_CHUNK("infoSlimeChunk", false, ""),
    LOOKING_AT_BLOCK("infoLookingAtBlock", false, ""),
    LOOKING_AT_BLOCK_CHUNK("infoLookingAtBlockInChunk", false, ""),
    BLOCK_PROPS("infoBlockProperties", false, ""),
    BEE_COUNT("infoBeeCount", false, true, ""),
    COMPARATOR_OUTPUT("infoComparatorOutput", false, true, ""),
    HONEY_LEVEL("infoHoneyLevel", false, ""),
    FURNACE_XP("infoFurnaceXp", false, true, ""),
    ENTITY_REG_NAME("infoEntityRegistryName", false, ""),
    LOOKING_AT_ENTITY("infoLookingAtEntity", false, ""),
    LOOKING_AT_EFFECTS("infoLookingAtEffects", false, ""),
    LOOKING_AT_PLAYER_EXP("infoLookingAtPlayerExp", false, ""),
    ZOMBIE_CONVERSION("infoZombieConversion", false, ""),
    HORSE_SPEED("infoHorseSpeed", false, ""),
    HORSE_JUMP("infoHorseJump", false, ""),
    PANDA_GENE("infoPandaGene", false, ""),
    DOLPHIN_TREASURE("infoDolphinTreasure", false, ""),
    ENTITY_VARIANT("infoEntityVariant", false, "");

    public static final ImmutableList<InfoToggle> VALUES;
    private static final String INFO_KEY = "minihud.config.info_toggle";
    private final String name;
    private String comment;
    private String prettyName;
    private String translatedName;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private final int defaultLinePosition;
    private boolean valueBoolean;
    private int linePosition;
    private static int nextDefaultLinePosition;
    private final boolean serverDataRequired;

    private static int getNextDefaultLinePosition() {
        return nextDefaultLinePosition++;
    }

    private InfoToggle(String name, boolean defaultValue, String defaultHotkey) {
        this(name, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, String defaultHotkey) {
        this(name, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, int linePosition, String defaultHotkey) {
        this(name, defaultValue, false, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey) {
        this(name, defaultValue, serverDataRequired, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, int linePosition, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, false, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey, KeybindSettings settings) {
        this(name, defaultValue, serverDataRequired, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), name);
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, String comment) {
        this(name, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), name);
    }

    private InfoToggle(String name, boolean defaultValue, String defaultHotkey, String comment, String translatedName) {
        this(name, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, translatedName, name);
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, String comment, String translatedName) {
        this(name, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, translatedName, name);
    }

    private InfoToggle(String name, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey, String comment, KeybindSettings settings, String translatedName, String prettyName) {
        this.name = name;
        this.valueBoolean = defaultValue;
        this.defaultValueBoolean = defaultValue;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback((IHotkeyCallback)new KeyCallbackToggleBoolean((IConfigBoolean)this));
        this.defaultLinePosition = linePosition;
        this.linePosition = linePosition;
        this.comment = comment;
        this.prettyName = prettyName;
        this.translatedName = translatedName;
        this.serverDataRequired = serverDataRequired;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + this.name + GuiBase.TXT_RST;
        }
        return this.name;
    }

    public String getPrettyName() {
        return StringUtils.getTranslatedOrFallback((String)this.prettyName, (String)(this.prettyName.isEmpty() ? StringUtils.splitCamelCase((String)this.name) : this.prettyName));
    }

    public String getConfigGuiDisplayName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public String getComment() {
        String comment = StringUtils.getTranslatedOrFallback((String)this.comment, (String)this.comment);
        if (comment != null && this.serverDataRequired) {
            return comment + "\n" + StringUtils.translate((String)"minihud.label.config_comment.server_side_data", (Object[])new Object[0]);
        }
        return comment;
    }

    public String getTranslatedName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public void setPrettyName(String s) {
        this.prettyName = s;
    }

    public void setTranslatedName(String s) {
        this.translatedName = s;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    private static String buildTranslateName(String name, String type) {
        return "minihud.config.info_toggle." + type + "." + name;
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        this.valueBoolean = value;
    }

    public int getIntegerValue() {
        return this.linePosition;
    }

    public int getDefaultIntegerValue() {
        return this.defaultLinePosition;
    }

    public void setIntegerValue(int value) {
        this.linePosition = value;
    }

    public int getMinIntegerValue() {
        return 0;
    }

    public int getMaxIntegerValue() {
        return InfoToggle.values().length - 1;
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return !String.valueOf(this.defaultValueBoolean).equals(newValue);
    }

    public void resetToDefault() {
        this.valueBoolean = this.defaultValueBoolean;
    }

    public void setValueFromString(String value) {
        try {
            this.valueBoolean = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName());
            }
        }
        catch (Exception e) {
            MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])InfoToggle.values());
    }
}

