/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge.mixins.client;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.coreapi.ModInfo;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow(remap=false)
    private ClientLevel level;
    @Unique
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    @Inject(at={@At(value="HEAD")}, method={"renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, cancellable=true)
    private void renderChunkLayer(RenderType renderType, double x, double y, double z, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, CallbackInfo callback) {
        ClientApi.RENDER_STATE.mcModelViewMatrix = McObjectConverter.Convert(modelViewMatrix);
        ClientApi.RENDER_STATE.mcProjectionMatrix = McObjectConverter.Convert(projectionMatrix);
        ClientApi.RENDER_STATE.frameTime = Minecraft.getInstance().deltaTracker.getRealtimeDeltaTicks();
        if (ModInfo.IS_DEV_BUILD) {
            ClientApi.RENDER_STATE.canRenderOrThrow();
        }
        if (renderType.equals(RenderType.solid())) {
            ClientApi.INSTANCE.renderLods(ClientLevelWrapper.getWrapper(this.level), ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime);
        } else if (renderType.equals(RenderType.translucent())) {
            ClientApi.INSTANCE.renderDeferredLodsForShaders(ClientLevelWrapper.getWrapper(this.level), ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime);
        }
        if (renderType.equals(RenderType.cutout())) {
            ClientApi.INSTANCE.renderFadeOpaque(ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime, ClientLevelWrapper.getWrapper(this.level));
        } else if (renderType.equals(RenderType.tripwire())) {
            ClientApi.INSTANCE.renderFade(ClientApi.RENDER_STATE.mcModelViewMatrix, ClientApi.RENDER_STATE.mcProjectionMatrix, ClientApi.RENDER_STATE.frameTime, ClientLevelWrapper.getWrapper(this.level));
        }
        if (Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) {
            callback.cancel();
        }
    }
}

