/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui;

import com.seibel.distanthorizons.api.enums.config.DisallowSelectingViaConfigGui;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.util.AnnotationUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.IConfigGui;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassicConfigGUI {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigCoreInterface CONFIG_CORE_INTERFACE = new ConfigCoreInterface();
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");

    private static void textField(AbstractConfigType info, Function<String, Number> func, Pattern pattern, boolean cast) {
        ((EntryInfo)info.guiValue).widget = (editBox, button) -> stringValue -> {
            boolean isNumber = pattern != null;
            if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                return false;
            }
            Number value = info.typeIsFloatingPointNumber() ? 0.0 : 0.0;
            ((EntryInfo)info.guiValue).error = null;
            if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                try {
                    value = (Number)func.apply((String)stringValue);
                }
                catch (Exception e) {
                    value = null;
                }
                byte isValid = ((ConfigEntry)info).isValid(value);
                switch (isValid) {
                    case 0: {
                        ((EntryInfo)info.guiValue).error = null;
                        break;
                    }
                    case -1: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<class_342, class_5250>((class_342)editBox, GuiHelper.TextOrTranslatable("\u00a7cMinimum length is " + String.valueOf(((ConfigEntry)info).getMin())));
                        break;
                    }
                    case 1: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<class_342, class_5250>((class_342)editBox, GuiHelper.TextOrTranslatable("\u00a7cMaximum length is " + String.valueOf(((ConfigEntry)info).getMax())));
                        break;
                    }
                    case 2: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<class_342, class_5250>((class_342)editBox, GuiHelper.TextOrTranslatable("\u00a7cValue is invalid"));
                    }
                }
            }
            ((EntryInfo)info.guiValue).tempValue = stringValue;
            editBox.method_1868(((ConfigEntry)info).isValid(value) == 0 ? -1 : -34953);
            if (info.getType() == String.class || info.getType() == List.class) {
                ((ConfigEntry)info).uiSetWithoutSaving(stringValue);
            } else if (((ConfigEntry)info).isValid(value) == 0) {
                if (!cast) {
                    ((ConfigEntry)info).uiSetWithoutSaving(value);
                } else {
                    ((ConfigEntry)info).uiSetWithoutSaving(value != null ? value.intValue() : 0);
                }
            }
            return true;
        };
    }

    public static class_437 getScreen(ConfigBase configBase, class_437 parent, String category) {
        return new ConfigScreen(configBase, parent, category);
    }

    private static void initEntry(AbstractConfigType configType, String translationPrefix) {
        configType.guiValue = new EntryInfo();
        Class<?> fieldClass = configType.getType();
        if (ConfigEntry.class.isAssignableFrom(configType.getClass())) {
            if (fieldClass == Integer.class) {
                ClassicConfigGUI.textField(configType, Integer::parseInt, INTEGER_ONLY_REGEX, true);
            } else if (fieldClass == Double.class) {
                ClassicConfigGUI.textField(configType, Double::parseDouble, DECIMAL_ONLY_REGEX, false);
            } else if (fieldClass == String.class || fieldClass == List.class) {
                ClassicConfigGUI.textField(configType, String::length, null, true);
            } else if (fieldClass == Boolean.class) {
                Function<Object, class_2561> func = value -> GuiHelper.Translatable("distanthorizons.general." + ((Boolean)value != false ? "true" : "false"), new Object[0]).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                ((EntryInfo)configType.guiValue).widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    ((ConfigEntry)configType).uiSetWithoutSaving((Boolean)configType.get() == false);
                    button.method_25355((class_2561)func.apply(configType.get()));
                }, func);
            } else if (fieldClass.isEnum()) {
                List<?> values = Arrays.asList(configType.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> GuiHelper.Translatable(translationPrefix + "enum." + fieldClass.getSimpleName() + "." + configType.get().toString(), new Object[0]);
                ((EntryInfo)configType.guiValue).widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int startingIndex = values.indexOf(configType.get());
                    Enum enumValue = (Enum)values.get(startingIndex);
                    int index = startingIndex + 1;
                    int n = index = index >= values.size() ? 0 : index;
                    while (index != startingIndex && AnnotationUtil.doesEnumHaveAnnotation(enumValue = (Enum)values.get(index), DisallowSelectingViaConfigGui.class)) {
                        index = ++index >= values.size() ? 0 : index;
                    }
                    if (index == startingIndex) {
                        enumValue = (Enum)values.get(startingIndex);
                        LOGGER.warn("Enum [" + String.valueOf(enumValue.getClass()) + "] doesn't contain any values that should be selectable via the UI, sticking to the currently selected value [" + String.valueOf(enumValue) + "].");
                    }
                    ((ConfigEntry)configType).uiSetWithoutSaving(enumValue);
                    button.method_25355((class_2561)func.apply(configType.get()));
                }, func);
            }
        } else if (ConfigCategory.class.isAssignableFrom(configType.getClass())) {
            // empty if block
        }
    }

    public static class EntryInfo {
        Object widget;
        Map.Entry<class_342, class_2561> error;
        String tempValue;
        int index;
    }

    private static class ConfigScreen
    extends DhScreen {
        private final ConfigBase configBase;
        private final String translationPrefix;
        private final class_437 parent;
        private final String category;
        private ConfigListWidget list;
        private boolean reload = false;
        private class_4185 doneButton;

        protected ConfigScreen(ConfigBase configBase, class_437 parent, String category) {
            super((class_2561)GuiHelper.Translatable(class_1074.method_4663((String)(configBase.modID + ".config" + (String)(category.isEmpty() ? "." + category : "") + ".title")) ? configBase.modID + ".config.title" : configBase.modID + ".config" + (String)(category.isEmpty() ? "" : "." + category) + ".title", new Object[0]));
            this.configBase = configBase;
            this.parent = parent;
            this.category = category;
            this.translationPrefix = configBase.modID + ".config.";
        }

        public void method_25393() {
            super.method_25393();
        }

        public void method_25419() {
            ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        protected void method_25426() {
            super.method_25426();
            if (!this.reload) {
                ConfigBase.INSTANCE.configFileINSTANCE.loadFromFile();
            }
            if (Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue() && !ModInfo.IS_DEV_BUILD) {
                this.addBtn(new TexturedButtonWidget(this.field_22789 - 28, this.field_22790 - 28, 20, 20, 0, 0, 0, class_2960.method_60655((String)"distanthorizons", (String)"textures/gui/changelog.png"), 20, 20, buttonWidget -> {
                    ChangelogScreen changelogScreen = new ChangelogScreen(this);
                    if (changelogScreen.usable) {
                        Objects.requireNonNull(this.field_22787).method_1507((class_437)changelogScreen);
                    } else {
                        LOGGER.warn("Changelog was not able to open");
                    }
                }, (class_2561)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
            }
            this.addBtn(GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.cancel", new Object[0]), this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20, button -> {
                ConfigBase.INSTANCE.configFileINSTANCE.loadFromFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            this.doneButton = this.addBtn(GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.done", new Object[0]), this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20, button -> {
                ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            this.list = new ConfigListWidget(this.field_22787, this.field_22789 * 2, this.field_22790, 32, 32, 25);
            this.method_25429((class_364)this.list);
            for (AbstractConfigType<?, ?> info : ConfigBase.INSTANCE.entries) {
                try {
                    if (!info.getCategory().matches(this.category) || !info.getAppearance().showInGui) continue;
                    this.addMenuItem(info);
                }
                catch (Exception e) {
                    String message = "ERROR: Failed to show [\" + info.getNameWCategory() + \"], error: [" + e.getMessage() + "]";
                    if (info.get() != null) {
                        message = message + " with the value [" + String.valueOf(info.get()) + "] with type [" + String.valueOf(info.getType()) + "]";
                    }
                    LOGGER.error(message, (Throwable)e);
                }
            }
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        private void addMenuItem(AbstractConfigType info) {
            class_4185 widget;
            ClassicConfigGUI.initEntry(info, this.translationPrefix);
            class_5250 name = GuiHelper.Translatable(this.translationPrefix + info.getNameWCategory(), new Object[0]);
            if (ConfigEntry.class.isAssignableFrom(info.getClass())) {
                class_4185.class_4241 btnAction = button -> {
                    ((ConfigEntry)info).uiSetWithoutSaving(((ConfigEntry)info).getDefaultValue());
                    ((EntryInfo)info.guiValue).index = 0;
                    this.reload = true;
                    Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                };
                int posX = this.field_22789 - 10 - 150 - 5 - 40;
                int posZ = 0;
                class_4185 resetButton = GuiHelper.MakeBtn((class_2561)GuiHelper.Translatable("distanthorizons.general.reset", new Object[0]).method_27692(class_124.field_1061), posX, posZ, 40, 20, btnAction);
                if (((EntryInfo)info.guiValue).widget instanceof Map.Entry) {
                    Map.Entry widget2 = (Map.Entry)((EntryInfo)info.guiValue).widget;
                    if (info.getType().isEnum()) {
                        widget2.setValue(value -> GuiHelper.Translatable(this.translationPrefix + "enum." + info.getType().getSimpleName() + "." + info.get().toString(), new Object[0]));
                    }
                    this.list.addButton((class_339)GuiHelper.MakeBtn((class_2561)((Function)widget2.getValue()).apply(info.get()), this.field_22789 - 150 - 10, 0, 150, 20, (class_4185.class_4241)widget2.getKey()), (class_339)resetButton, null, (class_2561)name);
                    return;
                }
                if (((EntryInfo)info.guiValue).widget != null) {
                    class_342 widget3 = new class_342(this.field_22793, this.field_22789 - 150 - 10 + 2, 0, 146, 20, (class_2561)GuiHelper.Translatable("", new Object[0]));
                    widget3.method_1880(150);
                    widget3.method_1867(String.valueOf(info.get()));
                    Predicate processor = (Predicate)((BiFunction)((EntryInfo)info.guiValue).widget).apply(widget3, this.doneButton);
                    widget3.method_1890(processor);
                    this.list.addButton((class_339)widget3, (class_339)resetButton, null, (class_2561)name);
                    return;
                }
            }
            if (ConfigCategory.class.isAssignableFrom(info.getClass())) {
                widget = GuiHelper.MakeBtn((class_2561)name, this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20, button -> {
                    ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
                    Objects.requireNonNull(this.field_22787).method_1507(ClassicConfigGUI.getScreen(this.configBase, this, ((ConfigCategory)info).getDestination()));
                });
                this.list.addButton((class_339)widget, null, null, null);
                return;
            }
            if (ConfigUIButton.class.isAssignableFrom(info.getClass())) {
                widget = GuiHelper.MakeBtn((class_2561)name, this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20, button -> ((ConfigUIButton)info).runAction());
                this.list.addButton((class_339)widget, null, null, null);
                return;
            }
            if (ConfigUIComment.class.isAssignableFrom(info.getClass())) {
                this.list.addButton(null, null, null, (class_2561)name);
                return;
            }
            if (ConfigUiLinkedEntry.class.isAssignableFrom(info.getClass())) {
                this.addMenuItem((AbstractConfigType)((ConfigUiLinkedEntry)info).get());
                return;
            }
            LOGGER.warn("Config [" + info.getNameWCategory() + "] failed to show. Please try something like changing its type.");
        }

        public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.list.method_25394(matrices, mouseX, mouseY, delta);
            this.DhDrawCenteredString(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
            if (this.configBase.modID.equals("distanthorizons")) {
                this.DhDrawString(matrices, this.field_22793, (class_2561)GuiHelper.TextOrLiteral("2.3.4-b"), 2, this.field_22790 - 10, 0xAAAAAA);
                if (SelfUpdater.deleteOldJarOnJvmShutdown) {
                    this.DhDrawString(matrices, this.field_22793, (class_2561)GuiHelper.Translatable(this.configBase.modID + ".updater.waitingForClose", new Object[0]), 4, this.field_22790 - 38, 0xFFFFFF);
                }
            }
            for (AbstractConfigType abstractConfigType : ConfigBase.INSTANCE.entries) {
                class_339 buttonWidget;
                class_2561 text;
                if (!abstractConfigType.getCategory().matches(this.category) || !abstractConfigType.getAppearance().showInGui || !this.list.getHoveredButton(mouseX, mouseY).isPresent() || (text = ButtonEntry.buttonsWithText.get(buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get())) == null) continue;
                AbstractConfigType newInfo = ConfigUiLinkedEntry.class.isAssignableFrom(abstractConfigType.getClass()) ? (AbstractConfigType)((ConfigUiLinkedEntry)abstractConfigType).get() : abstractConfigType;
                class_5250 name = GuiHelper.Translatable(this.translationPrefix + (String)(abstractConfigType.category.isEmpty() ? "" : abstractConfigType.category + ".") + abstractConfigType.getName(), new Object[0]);
                String key = this.translationPrefix + (String)(newInfo.category.isEmpty() ? "" : newInfo.category + ".") + newInfo.getName() + ".@tooltip";
                if (((EntryInfo)newInfo.guiValue).error != null && text.equals((Object)name)) {
                    this.DhRenderTooltip(matrices, this.field_22793, ((EntryInfo)newInfo.guiValue).error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!class_1074.method_4663((String)key) || text == null || !text.equals((Object)name)) continue;
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                for (String str : class_1074.method_4662((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add((class_2561)GuiHelper.TextOrTranslatable(str));
                }
                this.DhRenderComponentTooltip(matrices, this.field_22793, list, mouseX, mouseY);
            }
        }
    }

    private static class ConfigCoreInterface
    implements IConfigGui {
        public final ArrayList<Runnable> onScreenChangeListenerList = new ArrayList();

        private ConfigCoreInterface() {
        }

        @Override
        public void addOnScreenChangeListener(Runnable newListener) {
            this.onScreenChangeListenerList.add(newListener);
        }

        @Override
        public void removeOnScreenChangeListener(Runnable oldListener) {
            this.onScreenChangeListenerList.remove(oldListener);
        }
    }

    public static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        public final class_339 button;
        private final class_339 resetButton;
        private final class_339 indexButton;
        private final class_2561 text;
        private final List<class_339> children = new ArrayList<class_339>();
        public static final Map<class_339, class_2561> buttonsWithText = new HashMap<class_339, class_2561>();

        private ButtonEntry(class_339 button, class_2561 text, class_339 resetButton, class_339 indexButton) {
            buttonsWithText.put(button, text);
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
        }

        public static ButtonEntry create(class_339 button, class_2561 text, class_339 resetButton, class_339 indexButton) {
            return new ButtonEntry(button, text, resetButton, indexButton);
        }

        public void method_25343(class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null) {
                GuiHelper.SetY(this.button, y);
                this.button.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.resetButton != null) {
                GuiHelper.SetY(this.resetButton, y);
                this.resetButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.indexButton != null) {
                GuiHelper.SetY(this.indexButton, y);
                this.indexButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (!(this.text == null || this.text.getString().contains("spacer") && this.button == null)) {
                matrices.method_27535(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends class_4265<ButtonEntry> {
        class_327 textRenderer;

        public ConfigListWidget(class_310 minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight - (topMargin + botMargin), topMargin, itemSpacing);
            this.field_22744 = false;
            this.textRenderer = minecraftClient.field_1772;
        }

        public void addButton(class_339 button, class_339 resetButton, class_339 indexButton, class_2561 text) {
            this.method_25321((class_350.class_351)ButtonEntry.create(button, text, resetButton, indexButton));
        }

        public int method_25322() {
            return 10000;
        }

        public Optional<class_339> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.method_25396()) {
                if (buttonEntry.button == null || !buttonEntry.button.method_25405(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.button);
            }
            return Optional.empty();
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SpaceFromRightScreen = 10;
        public static final int ButtonWidthSpacing = 5;
        public static final int ResetButtonWidth = 40;
        public static final int ResetButtonHeight = 20;

        private ConfigScreenConfigs() {
        }
    }
}

