/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5223;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableInt;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.CreditButton;
import snownee.jade.gui.ItemButton;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.ProfileConfigScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.SmoothChasingValue;

public class HomeConfigScreen
extends class_437 {
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_437 parent;
    private final SmoothChasingValue titleY;
    private final List<TextParticle> particles = Lists.newArrayList();
    private final List<TextParticle> pendingParticles = Lists.newArrayList();
    private float ticks;
    private byte festival;
    private float nextParticleIn;
    private CreditButton creditButton;
    private boolean showTranslators;

    public HomeConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.jade.configuration"));
        this.parent = parent;
        this.titleY = new SmoothChasingValue().start(8.0f).target(32.0f).withSpeed(0.1f);
        LocalDate now = LocalDate.now();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        if (month == 12 && day >= 24 && day <= 26) {
            this.festival = 1;
        } else if (month == 6 && day == 28) {
            this.festival = (byte)2;
        } else if (month <= 2 && HomeConfigScreen.isLunarNewYear(now)) {
            this.festival = (byte)99;
        }
    }

    private static boolean isLunarNewYear(LocalDate now) {
        int newYearMonthAndDay;
        int year = now.getYear();
        switch (year) {
            case 2025: {
                int n = 129;
                break;
            }
            case 2026: {
                int n = 217;
                break;
            }
            case 2027: {
                int n = 206;
                break;
            }
            case 2028: {
                int n = 126;
                break;
            }
            case 2029: {
                int n = 213;
                break;
            }
            case 2030: {
                int n = 203;
                break;
            }
            case 2031: {
                int n = 123;
                break;
            }
            case 2032: {
                int n = 211;
                break;
            }
            case 2033: {
                int n = 131;
                break;
            }
            case 2034: {
                int n = 219;
                break;
            }
            case 2035: {
                int n = 208;
                break;
            }
            case 2036: {
                int n = 128;
                break;
            }
            case 2037: {
                int n = 215;
                break;
            }
            case 2038: {
                int n = 204;
                break;
            }
            case 2039: {
                int n = 124;
                break;
            }
            case 2040: {
                int n = 212;
                break;
            }
            case 2041: {
                int n = 201;
                break;
            }
            case 2042: {
                int n = 122;
                break;
            }
            case 2043: {
                int n = 210;
                break;
            }
            default: {
                int n = newYearMonthAndDay = 0;
            }
        }
        if (newYearMonthAndDay == 0) {
            return false;
        }
        int newYearMonth = newYearMonthAndDay / 100;
        int newYearDay = newYearMonthAndDay % 100;
        LocalDate newYearDate = LocalDate.of(year, newYearMonth, newYearDay);
        int newYearDayOfYear = newYearDate.getDayOfYear();
        int dayOfYear = now.getDayOfYear();
        return dayOfYear >= newYearDayOfYear - 1 && dayOfYear <= newYearDayOfYear + 2;
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        this.particles.clear();
        class_5250 modSettings = class_2561.method_43471((String)"gui.jade.jade_settings");
        class_5250 pluginSettings = class_2561.method_43471((String)"gui.jade.plugin_settings");
        class_5250 profileSettings = class_2561.method_43471((String)"gui.jade.profile_settings");
        int maxWidth = Math.max(100, Math.max(this.field_22793.method_27525((class_5348)modSettings) + 8, this.field_22793.method_27525((class_5348)pluginSettings) + 8));
        maxWidth = Math.min(maxWidth, Math.min(240, this.field_22789 / 2 - 40));
        this.method_37063((class_364)class_4185.method_46430((class_2561)modSettings, w -> {
            this.visitedChildScreen();
            this.field_22787.method_1507((class_437)new WailaConfigScreen(this));
        }).method_46434(this.field_22789 / 2 - 5 - maxWidth, this.field_22790 / 2 - 10, maxWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)pluginSettings, w -> {
            this.visitedChildScreen();
            this.field_22787.method_1507((class_437)new PluginsConfigScreen(this));
        }).method_46434(this.field_22789 / 2 + 5, this.field_22790 / 2 - 10, maxWidth, 20).method_46431());
        ItemButton profileButton = new ItemButton(this.field_22789 / 2 + 10 + maxWidth, this.field_22790 / 2 - 10, 20, 20, new class_1799((class_1935)class_1802.field_8407, 2), (class_2561)profileSettings, w -> {
            this.visitedChildScreen();
            this.field_22787.method_1507((class_437)new ProfileConfigScreen(this));
        }, class_4185.field_40754);
        profileButton.method_47400(class_7919.method_47407((class_2561)profileSettings));
        this.method_37063((class_364)profileButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, w -> this.method_25419()).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 20, 100, 20).method_46431());
        class_2583 style = class_2583.field_24360;
        if (this.festival != 0 && this.festival != 1) {
            style = style.method_36139(15852452);
        }
        class_5250 title = class_2561.method_43469((String)"gui.jade.by", (Object[])new Object[]{class_2561.method_43470((String)"\u2764").method_27692(class_124.field_1061)}).method_27696(style);
        class_5250 hoveredTitle = class_2561.method_43471((String)"gui.jade.by.hovered").method_27696(style);
        int btnWidth = this.field_22793.method_27525((class_5348)title);
        int btnX = (int)((float)this.field_22789 * 0.5f - (float)btnWidth * 0.5f);
        int btnY = (int)((float)this.field_22790 * 0.9f - 5.0f);
        class_5250 narration = class_2561.method_43471((String)(this.festival == 99 ? "narration.jade.by.lunar" : "narration.jade.by"));
        this.creditButton = (CreditButton)this.method_37063((class_364)new CreditButton(btnX, btnY, btnWidth, 10, (class_2561)title, (class_2561)hoveredTitle, b -> class_407.method_49623((class_437)this, (String)"https://www.curseforge.com/members/snownee_/projects"), this::triggerAuthorButton, arg_0 -> HomeConfigScreen.lambda$init$5((class_2561)narration, arg_0)));
        if (this.showTranslators) {
            this.creditButton.showTranslators();
        }
    }

    private void visitedChildScreen() {
        this.titleY.set(this.titleY.getTarget());
        this.showTranslators = true;
    }

    private void triggerAuthorButton(class_4185 button) {
        IntArrayList colors = new IntArrayList();
        String text = "\u2744";
        if (this.festival == 2) {
            this.festival = (byte)3;
        } else if (this.festival == 99) {
            for (i = 0; i < 11; ++i) {
                colors.add(this.random.method_43056() ? 0xA80000 : 12589056);
            }
            text = "\u2710";
        } else {
            for (i = 0; i < 11; ++i) {
                colors.add(class_9848.method_61318((float)1.0f, (float)(1.0f - this.random.method_43057() * 0.6f), (float)1.0f, (float)1.0f));
            }
        }
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            int ox = this.random.method_39332(-button.method_25368() / 2, button.method_25368() / 2);
            float x = (float)this.field_22789 * 0.5f + (float)ox;
            float y = this.random.method_39332(button.method_46427(), button.method_46427() + button.method_25364());
            float dx = (float)ox * 0.08f;
            float dy = -5.0f - this.random.method_43057() * 3.0f;
            TextParticle particle = new TextParticle(text, x, y, dx, dy, color, 0.75f + this.random.method_43057() * 0.5f);
            this.particles.add(particle);
            if (this.festival != 99) continue;
            particle.age = 8.0f + this.random.method_43057() * 5.0f;
        }
    }

    public void method_25419() {
        IWailaConfig.get().save();
        WailaClientRegistration.instance().reloadIgnoreLists();
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float scaledY;
        float scaledX;
        Objects.requireNonNull(this.field_22787);
        float deltaTicks = class_310.method_1551().method_61966().method_60638();
        this.ticks += deltaTicks;
        if (this.ticks > this.nextParticleIn) {
            if (this.festival == 3) {
                this.nextParticleIn = this.ticks + 1.0f;
                if (this.pendingParticles.isEmpty()) {
                    this.festival3populateNew();
                }
                TextParticle particle = this.pendingParticles.removeFirst();
                particle.x = mouseX - 5;
                particle.y = mouseY;
                this.particles.add(particle);
            } else if (this.festival == 1) {
                this.nextParticleIn = this.ticks + 10.0f + this.random.method_43057() * 10.0f;
                int color = class_9848.method_61318((float)1.0f, (float)(1.0f - this.random.method_43057() * 0.6f), (float)1.0f, (float)1.0f);
                int x = this.random.method_39332(40, this.field_22789 + 100);
                TextParticle particle = new TextParticle("\u2744", x, -20.0f, -0.3f, 0.5f, color |= this.random.method_43048(80) + 40 << 24, 2.0f + this.random.method_43057());
                particle.gravity = 0.0f;
                this.particles.add(particle);
            }
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        boolean smallUI = this.field_22787.method_22683().method_4495() < 3.0;
        int left = this.field_22789 / 2 - 105;
        int top = this.field_22790 / 4 - 20;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)left, (float)top, 0.0f);
        float scale = smallUI ? 2.0f : 1.5f;
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_25303(this.field_22793, ModIdentification.getModName("jade").orElse("Jade"), 0, 0, 0xFFFFFF);
        guiGraphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
        this.titleY.tick(deltaTicks);
        String desc2 = class_1074.method_4662((String)"gui.jade.configuration.desc2", (Object[])new Object[0]);
        if (desc2.isEmpty()) {
            guiGraphics.method_51448().method_22909();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)left, (float)top, 0.0f);
            scaledX = mouseX - left;
            scaledY = mouseY - top;
        } else {
            scaledX = (float)(mouseX - left) / scale * 2.0f;
            scaledY = (float)(mouseY - top) / scale * 2.0f;
        }
        this.drawFancyTitle(guiGraphics, class_1074.method_4662((String)"gui.jade.configuration.desc1", (Object[])new Object[0]), Math.min(this.titleY.value, 20.0f), 20.0f, scaledX, scaledY);
        if (!desc2.isEmpty()) {
            this.drawFancyTitle(guiGraphics, desc2, Math.min(this.titleY.value + 3.0f, 32.0f), 32.0f, scaledX, scaledY);
        }
        guiGraphics.method_51448().method_22909();
        this.particles.removeIf(p -> {
            p.tick(deltaTicks);
            if (p.y > (float)(this.field_22790 + 20)) {
                return true;
            }
            p.render(guiGraphics, this.field_22793);
            return false;
        });
    }

    private void festival3populateNew() {
        IntArrayList colors = new IntArrayList();
        String text = this.random.method_43056() ? "UwU" : "OwO";
        switch (this.random.method_43048(7)) {
            case 0: {
                colors.add(14942979);
                colors.add(16747520);
                colors.add(16772352);
                colors.add(32806);
                colors.add(7547266);
                colors.add(7547266);
                break;
            }
            case 1: {
                colors.add(6016762);
                colors.add(16099768);
                colors.add(0xFFFFFF);
                colors.add(16099768);
                colors.add(6016762);
                break;
            }
            case 2: {
                colors.add(14025328);
                colors.add(14025328);
                colors.add(10178454);
                colors.add(14504);
                colors.add(14504);
                break;
            }
            case 3: {
                colors.add(16720268);
                colors.add(16720268);
                colors.add(16766976);
                colors.add(16766976);
                colors.add(2208255);
                colors.add(2208255);
                break;
            }
            case 4: {
                colors.add(0);
                colors.add(0xA3A3A3);
                colors.add(0xFFFFFF);
                colors.add(0x800080);
                break;
            }
            case 5: {
                colors.add(16742052);
                colors.add(0xFFFFFF);
                colors.add(12587479);
                colors.add(0);
                colors.add(3095742);
                break;
            }
            case 6: {
                colors.add(16577588);
                colors.add(0xFFFFFF);
                colors.add(10246609);
                colors.add(0x2C2C2C);
            }
        }
        int ox = this.random.method_39332(this.creditButton.method_46426(), this.creditButton.method_46426() + this.creditButton.method_25368());
        float dx = (float)ox * 0.08f;
        float dy = -5.0f - this.random.method_43057() * 3.0f;
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            for (int i = 0; i < 5; ++i) {
                TextParticle particle = new TextParticle(text, 0.0f, 0.0f, dx, dy, color, 1.0f);
                this.pendingParticles.add(particle);
            }
        }
    }

    private void drawFancyTitle(class_332 guiGraphics, String text, float y, float expectY, float mouseX, float mouseY) {
        float distY = Math.abs(y - expectY);
        if (distY >= 9.0f) {
            return;
        }
        int color = IWailaConfig.Overlay.applyAlpha(0xAAAAAA, 1.0f - distY / 10.0f);
        float glint1 = (this.ticks - y / 5.0f) % 90.0f / 45.0f * (float)this.field_22789;
        float glint2 = mouseX;
        float glint1Strength = 1.0f;
        float glint2Strength = 1.0f - class_3532.method_15363((float)(Math.abs(mouseY - y) / 20.0f), (float)0.0f, (float)1.0f);
        class_5250 component = class_2561.method_43473();
        MutableInt curX = new MutableInt();
        class_5223.method_27479((String)text, (class_2583)class_2583.field_24360, (index, style, codePoint) -> {
            String s = Character.toString(codePoint);
            int width = this.field_22793.method_1727(s);
            int curXVal = curX.getValue();
            curX.add(width);
            float dist = Math.abs((float)(curXVal += width / 2) - glint1);
            float localGlint1 = 0.65f + class_3532.method_15363((float)(1.0f - dist / 20.0f), (float)0.0f, (float)1.0f) * 0.35f * glint1Strength;
            dist = Math.abs((float)curXVal - glint2);
            float localGlint2 = 0.65f + class_3532.method_15363((float)(1.0f - dist / 20.0f), (float)0.0f, (float)1.0f) * 0.35f * glint2Strength;
            float colorMul = Math.max(localGlint1, localGlint2);
            int originalColor = style.method_10973() == null ? 0xAAAAAA : style.method_10973().method_27716();
            component.method_10852((class_2561)class_2561.method_43470((String)s).method_27696(style).method_54663(class_9848.method_61321((int)originalColor, (float)colorMul)));
            return true;
        });
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, y, 0.0f);
        guiGraphics.method_27535(this.field_22793, (class_2561)component, 0, 0, color);
        guiGraphics.method_51448().method_22909();
    }

    private static /* synthetic */ class_5250 lambda$init$5(class_2561 narration, Supplier $) {
        return narration.method_27661();
    }

    private class TextParticle {
        private float age;
        private String text;
        private float x;
        private float y;
        private float motionX;
        private float motionY;
        private int color;
        private float scale;
        private float gravity = 0.98f;

        public TextParticle(String text, float x, float y, float motionX, float motionY, int color, float scale) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.motionX = motionX;
            this.motionY = motionY;
            this.color = color;
            this.scale = scale;
        }

        private void tick(float partialTicks) {
            this.x += this.motionX * partialTicks;
            this.y += this.motionY * partialTicks;
            this.motionY += this.gravity * partialTicks;
            if (HomeConfigScreen.this.festival == 99) {
                boolean greaterThanZero = this.age > 0.0f;
                this.age -= partialTicks;
                if (greaterThanZero && this.age <= 0.0f) {
                    this.text = HomeConfigScreen.this.random.method_43056() ? "\u2734" : "\u2733";
                    this.color = HomeConfigScreen.this.random.method_43056() ? 16765991 : 15778837;
                    Objects.requireNonNull(HomeConfigScreen.this.field_22787);
                    HomeConfigScreen.this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)(HomeConfigScreen.this.random.method_43056() ? class_3417.field_14917 : class_3417.field_15188), (float)0.7f));
                }
            } else if (HomeConfigScreen.this.festival == 1) {
                this.age -= partialTicks;
            }
        }

        private void render(class_332 guiGraphics, class_327 font) {
            if (HomeConfigScreen.this.festival == 99 && this.age < -4.0f) {
                return;
            }
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
            guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
            if (HomeConfigScreen.this.festival == 1) {
                guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(this.age));
            }
            guiGraphics.method_25303(font, this.text, 0, 0, this.color);
            guiGraphics.method_51448().method_22909();
        }
    }
}

