/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.tooltiptweaks.mixin;

import java.util.List;
import java.util.Optional;
import net.bunten.tooltiptweaks.tooltips.ConvertibleTooltips;
import net.bunten.tooltiptweaks.tooltips.text.AxolotlVariantTooltip;
import net.bunten.tooltiptweaks.tooltips.text.ClockTooltips;
import net.bunten.tooltiptweaks.tooltips.text.CompassTooltips;
import net.bunten.tooltiptweaks.tooltips.text.ContainerTooltips;
import net.bunten.tooltiptweaks.tooltips.text.DurabilityTooltips;
import net.bunten.tooltiptweaks.tooltips.text.InstrumentTooltip;
import net.bunten.tooltiptweaks.tooltips.text.NutritionTooltips;
import net.bunten.tooltiptweaks.tooltips.text.RepairCostTooltip;
import net.bunten.tooltiptweaks.tooltips.text.StatusEffectTooltips;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1792.class})
public abstract class ItemMixin {
    @Inject(method={"getTooltipData"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTooltipData(class_1799 stack, CallbackInfoReturnable<Optional<class_5632>> info) {
        ConvertibleTooltips.CONVERTIBLE_TOOLTIP_DATA_REGISTRY.forEach(data -> {
            if (data.canDisplay(stack)) {
                info.setReturnValue(Optional.of(data.withStack(stack)));
            }
        });
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")})
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type, CallbackInfo ci) {
        new DurabilityTooltips().register(stack, tooltip);
        new RepairCostTooltip().register(stack, tooltip);
        new NutritionTooltips().register(stack, tooltip);
        new StatusEffectTooltips().register(stack, tooltip);
        new AxolotlVariantTooltip().register(stack, tooltip);
        new ClockTooltips().register(stack, tooltip);
        new CompassTooltips().register(stack, tooltip);
        new ContainerTooltips().register(stack, tooltip);
        new InstrumentTooltip().register(stack, tooltip);
    }
}

