/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.tooltiptweaks.tooltips.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.bunten.tooltiptweaks.TooltipTweaksMod;
import net.bunten.tooltiptweaks.config.TooltipTweaksConfig;
import net.bunten.tooltiptweaks.config.options.IconLocation;
import net.bunten.tooltiptweaks.config.options.NourishmentDisplay;
import net.bunten.tooltiptweaks.config.options.NourishmentStyle;
import net.bunten.tooltiptweaks.tooltips.AbstractTooltip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_5348;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class FoodTooltipGUI
extends AbstractTooltip {
    private class_1799 stack;
    private class_4174 component;
    private final TooltipTweaksConfig config = TooltipTweaksConfig.getInstance();
    private static final class_2960 FOOD_HALF_TEXTURE = class_2960.method_60656((String)"hud/food_half");
    private static final class_2960 FOOD_FULL_TEXTURE = class_2960.method_60656((String)"hud/food_full");
    private static final class_2960 SATURATION_HALF_TEXTURE = TooltipTweaksMod.id("hud/saturation_half");
    private static final class_2960 SATURATION_FULL_TEXTURE = TooltipTweaksMod.id("hud/saturation_full");

    @Override
    public AbstractTooltip withStack(class_1799 stack) {
        this.stack = stack;
        this.component = (class_4174)stack.method_57824(class_9334.field_50075);
        return this;
    }

    @Override
    public boolean canDisplay(class_1799 stack) {
        if (this.config.nourishmentStyle != NourishmentStyle.ICONS) {
            return false;
        }
        if (this.config.nourishmentDisplay == NourishmentDisplay.DISABLED) {
            return false;
        }
        if (stack.method_31574(class_1802.field_50140)) {
            return false;
        }
        return stack.method_57353().method_57832(class_9334.field_50075) || stack.method_31574(class_1802.field_17534);
    }

    @Override
    public int method_32664(class_327 textRenderer) {
        int offset = this.config.nourishmentIconLocation == IconLocation.BELOW ? 0 : textRenderer.method_27525((class_5348)this.stack.method_7964());
        int width = this.getNutrition() * 4;
        if (this.config.nourishmentDisplay == NourishmentDisplay.NUTRITION_AND_SATURATION) {
            width = Math.max(width, this.getSaturation() * 4);
        }
        return offset + width + 4;
    }

    @Override
    public int method_32661(class_327 textRenderer) {
        return this.config.nourishmentIconLocation == IconLocation.BELOW ? 12 : 0;
    }

    private int getNutrition() {
        return this.stack.method_31574(class_1802.field_17534) ? 14 : this.component.comp_2491();
    }

    private int getSaturation() {
        float value = this.stack.method_31574(class_1802.field_17534) ? 2.8f : this.component.comp_2492();
        return (int)value;
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        RenderSystem.enableBlend();
        int xOffset = this.config.nourishmentIconLocation == IconLocation.BESIDE ? textRenderer.method_27525((class_5348)this.stack.method_7964()) + 2 : 0;
        int yOffset = this.config.nourishmentIconLocation == IconLocation.BESIDE ? -12 : 0;
        int rx = x + xOffset;
        int ry = y + yOffset;
        for (int index = 0; index < 10; ++index) {
            if (index * 2 + 1 < this.getNutrition()) {
                context.method_52706(class_1921::method_62277, FOOD_FULL_TEXTURE, rx + index * 8, ry, 9, 9);
            }
            if (index * 2 + 1 == this.getNutrition()) {
                context.method_52706(class_1921::method_62277, FOOD_HALF_TEXTURE, rx + index * 8, ry, 9, 9);
            }
            if (this.config.nourishmentDisplay != NourishmentDisplay.NUTRITION_AND_SATURATION) continue;
            if (index * 2 + 1 < this.getSaturation()) {
                context.method_52706(class_1921::method_62277, SATURATION_FULL_TEXTURE, rx + index * 8, ry, 9, 9);
            }
            if (index * 2 + 1 != this.getSaturation()) continue;
            context.method_52706(class_1921::method_62277, SATURATION_HALF_TEXTURE, rx + index * 8, ry, 9, 9);
        }
        RenderSystem.disableBlend();
    }
}

