/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.tooltiptweaks.tooltips.text;

import java.util.List;
import net.bunten.tooltiptweaks.config.TooltipTweaksConfig;
import net.bunten.tooltiptweaks.config.options.ClockTimeDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClockTooltips {
    private final class_310 client = class_310.method_1551();
    private final TooltipTweaksConfig config = TooltipTweaksConfig.getInstance();
    private static final class_5250 UNKNOWN_TEXT = class_2561.method_43471((String)"tooltiptweaks.ui.unknown");

    public static class_5250 getClockText(class_638 world) {
        class_5250 value = UNKNOWN_TEXT;
        if (world.method_8597().comp_645()) {
            boolean twelveHour = TooltipTweaksConfig.getInstance().clockTimeDisplay == ClockTimeDisplay.TWELVE_HOUR;
            long time = class_310.method_1551().field_1687.method_8532();
            int hour = (int)((time / 1000L + 6L) % 24L);
            int minute = (int)(60L * (time % 1000L) / 1000L);
            int displayedHour = twelveHour ? (hour % 12 == 0 ? 12 : hour % 12) : hour;
            String hourDisplay = twelveHour ? String.format("%d", displayedHour) : String.format("%02d", displayedHour);
            String minuteDisplay = String.format("%02d", minute);
            class_5250 suffix = twelveHour ? class_2561.method_43471((String)("tooltiptweaks.ui.clock." + (hour >= 12 ? "pm" : "am"))) : class_2561.method_43470((String)"");
            value = class_2561.method_43469((String)"tooltiptweaks.ui.clock.time.value", (Object[])new Object[]{hourDisplay, minuteDisplay, suffix});
        }
        return class_2561.method_43469((String)"tooltiptweaks.ui.clock.time", (Object[])new Object[]{value});
    }

    public static class_5250 getDayText(class_638 world) {
        class_5250 value = !world.method_8597().comp_645() ? UNKNOWN_TEXT : class_2561.method_43470((String)String.valueOf(world.method_8532() / 24000L));
        return class_2561.method_43469((String)"tooltiptweaks.ui.clock.day_number", (Object[])new Object[]{value});
    }

    public static class_5250 getMoonPhaseText(class_638 world) {
        class_5250 value = !world.method_8597().comp_645() ? UNKNOWN_TEXT : class_2561.method_43471((String)("tooltiptweaks.ui.clock.moon_phase.value_" + world.method_30273()));
        return class_2561.method_43469((String)"tooltiptweaks.ui.clock.moon_phase", (Object[])new Object[]{value});
    }

    public void register(class_1799 stack, List<class_2561> lines) {
        @Nullable class_638 world = this.client.field_1687;
        if (!stack.method_31574(class_1802.field_8557) || world == null) {
            return;
        }
        class_5250 dayText = ClockTooltips.getDayText(world);
        class_5250 timeText = ClockTooltips.getClockText(world);
        class_5250 phaseText = ClockTooltips.getMoonPhaseText(world);
        if (this.config.displayDayNumber && this.config.clockTimeDisplay == ClockTimeDisplay.DISABLED) {
            lines.add((class_2561)dayText.method_27692(class_124.field_1080));
        }
        if (this.config.clockTimeDisplay != ClockTimeDisplay.DISABLED) {
            class_5250 value = this.config.displayDayNumber ? class_2561.method_43469((String)"tooltiptweaks.ui.clock.multiple_values", (Object[])new Object[]{dayText, timeText}) : timeText;
            lines.add((class_2561)value.method_27692(class_124.field_1080));
        }
        if (this.config.displayMoonPhase) {
            lines.add((class_2561)phaseText.method_27692(class_124.field_1080));
        }
    }
}

