/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.tooltiptweaks.tooltips.text;

import com.ibm.icu.text.DecimalFormat;
import java.util.List;
import net.bunten.tooltiptweaks.config.TooltipTweaksConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class DurabilityTooltips {
    private final class_310 client = class_310.method_1551();
    private final TooltipTweaksConfig config = TooltipTweaksConfig.getInstance();

    private DecimalFormat getDurabilityDecimalFormat() {
        Object string = "#";
        for (int i = 0; i < this.config.percentageDigits; ++i) {
            if (i == 0) {
                string = (String)string + ".";
            }
            string = (String)string + "#";
        }
        return new DecimalFormat((String)string);
    }

    private int getDurabilityTextColor(float max, float damage) {
        float f = Math.max(0.0f, (max - damage) / max);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void register(class_1799 stack, List<class_2561> lines) {
        class_5250 message;
        if (!stack.method_7963() || !stack.method_7986()) {
            return;
        }
        float max = stack.method_7936();
        float damage = stack.method_7919();
        float durability = max - damage;
        float percent = durability / max * 100.0f;
        switch (this.config.durabilityStyle) {
            case PERCENTAGE: {
                message = class_2561.method_43469((String)"tooltiptweaks.ui.durability", (Object[])new Object[]{this.getDurabilityDecimalFormat().format((double)percent) + "%"});
                lines.add((class_2561)message.method_10862(message.method_10866().method_36139(this.getDurabilityTextColor(max, damage))));
                break;
            }
            case FRACTION: {
                message = class_2561.method_43469((String)"tooltiptweaks.ui.durability", (Object[])new Object[]{(int)durability + " / " + (int)max});
                lines.add((class_2561)message.method_10862(message.method_10866().method_36139(this.getDurabilityTextColor(max, damage))));
                break;
            }
        }
        if (this.config.displayUsesLeft && percent <= 25.0f) {
            message = class_2561.method_43469((String)"tooltiptweaks.ui.uses_left", (Object[])new Object[]{new DecimalFormat("#").format((double)durability)});
            lines.add((class_2561)message.method_10862(message.method_10866().method_36139(this.getDurabilityTextColor(max, damage))));
        }
    }
}

