/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.tooltiptweaks.tooltips.text;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.bunten.tooltiptweaks.TooltipTweaksMod;
import net.bunten.tooltiptweaks.config.TooltipTweaksConfig;
import net.bunten.tooltiptweaks.config.options.EffectDisplay;
import net.bunten.tooltiptweaks.config.options.OtherEffectDisplay;
import net.bunten.tooltiptweaks.tooltips.CommonText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10124;
import net.minecraft.class_10129;
import net.minecraft.class_10132;
import net.minecraft.class_10133;
import net.minecraft.class_10137;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1833;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4081;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9298;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class StatusEffectTooltips {
    private final class_310 client = class_310.method_1551();
    private final TooltipTweaksConfig config = TooltipTweaksConfig.getInstance();
    private List<class_1293> statusEffects;
    private EffectDisplay style;

    private boolean configAllows(class_1799 stack) {
        if (stack.method_7909() instanceof class_1812 || stack.method_31574(class_1802.field_50140)) {
            return this.config.updatePotionTooltips;
        }
        if (stack.method_31574(class_1802.field_8087) || stack.method_31574(class_1802.field_8236)) {
            return this.config.updateTippedArrowTooltips;
        }
        return true;
    }

    public void gatherEffects(class_1799 stack) {
        class_9331 component = class_9334.field_53964;
        this.style = this.config.foodEffectDisplay;
        if (stack.method_31574(class_1802.field_8766)) {
            component = class_9334.field_49652;
            this.style = this.config.stewEffectDisplay;
        }
        if (stack.method_7909() instanceof class_1812 || stack.method_7909() instanceof class_1833) {
            component = class_9334.field_49651;
            this.style = EffectDisplay.ALL_EFFECTS;
        }
        if (stack.method_31574(class_1802.field_50140)) {
            component = class_9334.field_50238;
            this.style = EffectDisplay.ALL_EFFECTS;
        }
        this.statusEffects = this.getAppliedStatusEffects(stack, component);
    }

    private List<class_1293> getAppliedStatusEffects(class_1799 stack, class_9331<?> component) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        if (stack.method_31574(class_1802.field_8236)) {
            effects.add(new class_1293(class_1294.field_5912, 200, 0));
            return effects;
        }
        if (!stack.method_57826(component)) {
            return effects;
        }
        if (component == class_9334.field_53964) {
            ((class_10124)stack.method_57824(class_9334.field_53964)).comp_3089().forEach(entry -> {
                if (entry instanceof class_10132) {
                    class_10132 effect = (class_10132)entry;
                    effects.addAll(effect.comp_3094());
                }
            });
        }
        if (component == class_9334.field_49652) {
            ((class_9298)stack.method_57824(class_9334.field_49652)).comp_2416().forEach(effect -> effects.add(effect.method_53247()));
        }
        if (component == class_9334.field_49651) {
            ((class_1844)stack.method_57824(class_9334.field_49651)).method_57397().forEach(effects::add);
        }
        if (component == class_9334.field_50238) {
            class_10129 amplifier = (class_10129)stack.method_57824(class_9334.field_50238);
            return List.of(new class_1293(class_1294.field_16595, 120000, amplifier.comp_3090(), false, false, true));
        }
        return effects;
    }

    private void addAppliedStatusEffects(class_1799 stack, List<class_2561> lines) {
        boolean isWaterBottle;
        boolean isPotion = stack.method_7909() instanceof class_1812;
        boolean bl = isWaterBottle = isPotion && ((class_1844)stack.method_57824(class_9334.field_49651)).comp_2378().isPresent() && ((class_1844)stack.method_57824(class_9334.field_49651)).comp_2378().get() == class_1847.field_8991;
        if (!isPotion && this.statusEffects.isEmpty() || isWaterBottle) {
            return;
        }
        if (isPotion && this.statusEffects.isEmpty()) {
            CommonText.addStatusEffectHeader(lines);
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1063)));
            return;
        }
        List<class_1293> filtered = this.statusEffects.stream().filter(instance -> this.style == EffectDisplay.POSITIVE_EFFECTS_ONLY && !TooltipTweaksMod.creative() ? ((class_1291)instance.method_5579().comp_349()).method_18792() != class_4081.field_18272 : true).toList();
        if (!filtered.isEmpty()) {
            CommonText.addStatusEffectHeader(lines);
            filtered.forEach(instance -> {
                class_4081 category = ((class_1291)instance.method_5579().comp_349()).method_18792();
                class_5250 text = class_2561.method_43471((String)instance.method_5586());
                if (instance.method_5578() > 0) {
                    text = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{text, class_2561.method_43471((String)("potion.potency." + instance.method_5578()))});
                }
                if (instance.method_5584() > 20) {
                    text = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{text, class_1292.method_5577((class_1293)instance, (float)(stack.method_31574(class_1802.field_8150) ? 0.25f : 1.0f), (float)this.client.field_1687.method_54719().method_54748())});
                }
                class_124 formatting = switch (category) {
                    case class_4081.field_18271 -> CommonText.BENEFICIAL_STATUS_EFFECT_COLOR;
                    case class_4081.field_18273 -> CommonText.NEUTRAL_STATUS_EFFECT_COLOR;
                    default -> CommonText.HARMFUL_STATUS_EFFECT_COLOR;
                };
                lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)text.method_27692(formatting)));
            });
        }
    }

    public void addRemoveEffectTooltips(class_1799 stack, List<class_2561> lines) {
        if (OtherEffectDisplay.canDisplay(this.config.modifierDisplay) && stack.method_57826(class_9334.field_53964)) {
            class_10124 component = (class_10124)stack.method_57824(class_9334.field_53964);
            component.comp_3089().forEach(effect -> {
                if (effect instanceof class_10137) {
                    class_10137 remove = (class_10137)effect;
                    remove.comp_3099().forEach(entry -> {
                        CommonText.addStatusEffectHeader(lines);
                        lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"tooltiptweaks.ui.removes_prefix", (Object[])new Object[]{class_2561.method_43471((String)((class_1291)entry.comp_349()).method_5567())}).method_27692(CommonText.NEUTRAL_STATUS_EFFECT_COLOR)));
                    });
                }
                if (effect instanceof class_10133) {
                    CommonText.addStatusEffectHeader(lines);
                    lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"tooltiptweaks.ui.removes_all_effects").method_27692(CommonText.NEUTRAL_STATUS_EFFECT_COLOR)));
                }
            });
        }
    }

    private void addModifiers(List<class_2561> lines) {
        if (this.statusEffects.isEmpty()) {
            return;
        }
        ArrayList modifiers = new ArrayList();
        this.statusEffects.forEach(instance -> ((class_1291)instance.method_5579().comp_349()).method_55650(instance.method_5578(), (attribute, modifier) -> modifiers.add(new Pair(attribute, modifier))));
        if (modifiers.isEmpty()) {
            return;
        }
        CommonText.addModifiersHeader(lines);
        modifiers.forEach(pair -> {
            class_1322 modifier = (class_1322)pair.getSecond();
            double value = modifier.comp_2450() != class_1322.class_1323.field_6330 && modifier.comp_2450() != class_1322.class_1323.field_6331 ? modifier.comp_2449() : modifier.comp_2449() * 100.0;
            String modifierKey = modifier.comp_2449() > 0.0 ? "attribute.modifier.plus." : "attribute.modifier.take.";
            lines.add((class_2561)class_2561.method_43469((String)(modifierKey + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(Math.abs(value)), class_2561.method_43471((String)((class_1320)((class_6880)pair.getFirst()).comp_349()).method_26830())}).method_27692(modifier.comp_2449() > 0.0 ? CommonText.POSITIVE_MODIFIER_COLOR : CommonText.NEGATIVE_MODIFIER_COLOR));
        });
    }

    public void register(class_1799 stack, List<class_2561> lines) {
        this.gatherEffects(stack);
        if (EffectDisplay.canDisplay(this.style) && this.configAllows(stack)) {
            this.addAppliedStatusEffects(stack, lines);
        }
        if (OtherEffectDisplay.canDisplay(this.config.otherEffectDisplay)) {
            this.addRemoveEffectTooltips(stack, lines);
        }
        if (OtherEffectDisplay.canDisplay(this.config.modifierDisplay)) {
            this.addModifiers(lines);
        }
    }
}

