/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRecipeUpdateEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.utils.value.BooleanValue;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.addon.ConfigAddonRegistryImpl;
import me.shedaniel.rei.impl.client.entry.filtering.rules.FilteringRuleTypeRegistryImpl;
import me.shedaniel.rei.impl.client.entry.renderer.EntryRendererRegistryImpl;
import me.shedaniel.rei.impl.client.favorites.DelegatingFavoriteEntryProviderImpl;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.client.gui.widget.TooltipContextImpl;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.client.registry.category.CategoryRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.screen.ScreenRegistryImpl;
import me.shedaniel.rei.impl.client.search.SearchProviderImpl;
import me.shedaniel.rei.impl.client.search.SearchRuntime;
import me.shedaniel.rei.impl.client.search.method.InputMethodRegistryImpl;
import me.shedaniel.rei.impl.client.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.impl.client.transfer.SimpleTransferHandlerImpl;
import me.shedaniel.rei.impl.client.transfer.TransferHandlerRegistryImpl;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import me.shedaniel.rei.impl.common.networking.DisplaySyncPacket;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.plugins.ReloadManagerImpl;
import me.shedaniel.rei.impl.common.util.InstanceHelper;
import me.shedaniel.rei.impl.common.util.IssuesDetector;
import me.shedaniel.rei.plugin.test.REITestCommonPlugin;
import me.shedaniel.rei.plugin.test.REITestPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10266;
import net.minecraft.class_10286;
import net.minecraft.class_10297;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_507;
import net.minecraft.class_5455;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RoughlyEnoughItemsCoreClient {
    public static final Event<BiConsumer<class_10286, class_5455>> PRE_UPDATE_RECIPES = EventFactory.createLoop((Object[])new BiConsumer[0]);
    public static final Event<Runnable> POST_UPDATE_TAGS = EventFactory.createLoop((Object[])new Runnable[0]);
    public static boolean isLeftMousePressed = false;

    public static void attachClientInternals() {
        InternalWidgets.attach();
        EmptyEntryDefinition.EmptyRenderer emptyEntryRenderer = new EmptyEntryDefinition.EmptyRenderer();
        ClientInternals.attachInstance(() -> emptyEntryRenderer, "emptyEntryRenderer");
        ClientInternals.attachInstance(DelegatingFavoriteEntryProviderImpl::new, "delegateFavoriteEntry");
        ClientInternals.attachInstance(object -> {
            String type = object.method_10558("type");
            class_2960 id = class_2960.method_60654((String)type);
            FavoriteEntryType entryType = FavoriteEntryType.registry().get(id);
            if (entryType == null) {
                return DataResult.error(() -> "Unknown favorite type: " + String.valueOf(id) + ", json: " + String.valueOf(object));
            }
            return entryType.read((class_2487)object);
        }, "favoriteEntryFromJson");
        ClientInternals.attachInstance(QueuedTooltip::impl, "tooltipProvider");
        ClientInternals.attachInstance(TooltipContextImpl::new, "tooltipContextProvider");
        ClientInternals.attachInstance(QueuedTooltip.TooltipEntryImpl::new, "tooltipEntryProvider");
        ClientInternals.attachInstance(SubMenuEntry::new, "subMenuEntry");
        ClientInternals.attachInstance((text, value) -> ToggleMenuEntry.of(text, () -> ((BooleanValue)value).get(), (BooleanConsumer)value), "toggleEntry");
        ClientInternals.attachInstanceSupplier(SimpleTransferHandlerImpl.INSTANCE, "simpleTransferHandler");
        ClientInternals.attachInstance(successful -> new ClickArea.Result((Boolean)successful){
            private List<CategoryIdentifier<?>> categories = Lists.newArrayList();
            private BooleanSupplier execute = () -> false;
            private Supplier<class_2561 @Nullable []> tooltip = () -> {
                if (this.categories != null && !this.categories.isEmpty()) {
                    class_2561 collect = CollectionUtils.mapAndJoinToComponent(this.categories, identifier -> CategoryRegistry.getInstance().tryGet(identifier).map(config -> config.getCategory().getTitle()).orElse((class_2561)class_2561.method_43470((String)identifier.toString())), (class_2561)class_2561.method_43470((String)", "));
                    return new class_2561[]{class_2561.method_43469((String)"text.rei.view_recipes_for", (Object[])new Object[]{collect})};
                }
                return null;
            };
            final /* synthetic */ Boolean val$successful;
            {
                this.val$successful = bl;
            }

            @Override
            public ClickArea.Result executor(BooleanSupplier task) {
                this.execute = task;
                return this;
            }

            @Override
            public ClickArea.Result category(CategoryIdentifier<?> category) {
                this.categories.add(category);
                return this;
            }

            @Override
            public ClickArea.Result tooltip(Supplier<class_2561 @Nullable []> tooltip) {
                this.tooltip = tooltip;
                return this;
            }

            @Override
            public boolean isSuccessful() {
                return this.val$successful;
            }

            @Override
            public boolean execute() {
                return this.execute.getAsBoolean();
            }

            @Override
            public class_2561 @Nullable [] getTooltips() {
                return this.tooltip.get();
            }

            @Override
            public Stream<CategoryIdentifier<?>> getCategories() {
                return this.categories.stream();
            }
        }, "clickAreaHandlerResult");
        ClientInternals.attachInstanceSupplier(new FilteringRuleTypeRegistryImpl(), "filteringRuleTypeRegistry");
        ClientInternals.attachInstanceSupplier(new PluginManagerImpl<REIClientPlugin>(REIClientPlugin.class, new EntryRendererRegistryImpl(), new ViewsImpl(), new InputMethodRegistryImpl(), new SearchProviderImpl(), new ConfigManagerImpl(), new EntryRegistryImpl(), new CollapsibleEntryRegistryImpl(), FilteringRuleTypeRegistry.getInstance().basic(), new CategoryRegistryImpl(), new DisplayRegistryImpl(), new ScreenRegistryImpl(), new FavoriteEntryTypeRegistryImpl(), new SubsetsRegistryImpl(), new TransferHandlerRegistryImpl(), new SearchRuntime(), new REIRuntimeImpl(), new ConfigAddonRegistryImpl()), "clientPluginManager");
    }

    public void onInitializeClient() {
        IssuesDetector.detect();
        this.registerEvents();
        RoughlyEnoughItemsCore.getPluginDetector().detectClientPlugins().get().run();
        this.loadTestPlugins();
        class_310 client = class_310.method_1551();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (buf, context) -> {
            class_1799 stack = (class_1799)buf.method_49394(class_1799.field_49266);
            String player = buf.method_10800(Short.MAX_VALUE);
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", EntryStacks.of(stack.method_7972()).asFormattedText().getString()).replaceAll("\\{item_count}", "" + stack.method_7972().method_7947()).replaceAll("\\{player_name}", player)), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)RoughlyEnoughItemsNetwork.NOT_ENOUGH_ITEMS_PACKET, (buf, context) -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof class_479) {
                class_479 class_4792 = (class_479)currentScreen;
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), DisplaySyncPacket.TYPE, DisplaySyncPacket.STREAM_CODEC, List.of(new SplitPacketTransformer()), DisplaySyncPacket::handle);
    }

    private void loadTestPlugins() {
        if (System.getProperty("rei.test", "false").equals("true")) {
            PluginView.getClientInstance().registerPlugin(new REITestPlugin());
            PluginView.getInstance().registerPlugin(new REITestCommonPlugin());
        }
    }

    public static boolean shouldReturn(class_437 screen) {
        if (REIRuntime.getInstance().getOverlay().isEmpty()) {
            return true;
        }
        if (screen == null) {
            return true;
        }
        if (screen != class_310.method_1551().field_1755) {
            return true;
        }
        return RoughlyEnoughItemsCoreClient._shouldReturn(screen);
    }

    private static ScreenOverlay getOverlay() {
        return REIRuntime.getInstance().getOverlay().orElseThrow(() -> new IllegalStateException("Overlay not initialized!"));
    }

    private static boolean _shouldReturn(class_437 screen) {
        try {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(screen)) {
                class_1269 result = decider.shouldScreenBeOverlaid(screen);
                if (result == class_1269.field_5811) continue;
                return result == class_1269.field_5814 || REIRuntime.getInstance().getPreviousScreen() == null;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return true;
    }

    private void registerEvents() {
        class_310 client = class_310.method_1551();
        class_2960 recipeButtonTex = class_2960.method_60656((String)"textures/gui/recipe_button.png");
        MutableLong endReload = new MutableLong(-1L);
        PRE_UPDATE_RECIPES.register((recipeAccess, registryAccess) -> RoughlyEnoughItemsCoreClient.reloadPlugins(null, ReloadStage.START, registryAccess));
        ClientRecipeUpdateEvent.EVENT.register(recipeManager -> RoughlyEnoughItemsCoreClient.reloadPlugins(endReload, ReloadStage.END));
        ClientRecipeUpdateEvent.ADD.register((recipeAccess, entries) -> {
            if (ClientHelperImpl.getInstance().canUsePackets()) {
                return;
            }
            InternalLogger.getInstance().debug("Received server's request to add %d recipes.", entries.size());
            DisplayRegistryImpl registry = (DisplayRegistryImpl)DisplayRegistry.getInstance();
            List<class_10297> mapped = CollectionUtils.map(entries, class_10266.class_10267::comp_3233);
            registry.addJob(() -> registry.addRecipes(mapped));
        });
        ClientRecipeUpdateEvent.REMOVE.register((recipeAccess, entries) -> {
            if (ClientHelperImpl.getInstance().canUsePackets()) {
                return;
            }
            InternalLogger.getInstance().debug("Received server's request to remove %d recipes.", entries.size());
            DisplayRegistryImpl registry = (DisplayRegistryImpl)DisplayRegistry.getInstance();
            HashSet ids = new HashSet(entries);
            registry.addJob(() -> registry.removeRecipes(ids));
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            InternalLogger.getInstance().debug("Player quit, clearing reload tasks!");
            endReload.setValue(-1L);
            ReloadManagerImpl.terminateReloadTasks();
        });
        ClientGuiEvent.INIT_PRE.register((screen, access) -> {
            List<ReloadStage> stages = ((PluginManagerImpl)PluginManager.getInstance()).getObservedStages();
            if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null && stages.contains((Object)ReloadStage.START) && !stages.contains((Object)ReloadStage.END) && !PluginManager.areAnyReloading() && screen instanceof class_465) {
                if (ReloadManagerImpl.countRunningReloadTasks() > 0) {
                    return EventResult.pass();
                }
                InternalLogger.getInstance().error("Detected missing stage: END! This is possibly due to issues during client recipe reload! REI will force a reload of the recipes now!");
                RoughlyEnoughItemsCoreClient.reloadPlugins(endReload, ReloadStage.END);
            }
            return EventResult.pass();
        });
        ClientGuiEvent.INIT_POST.register((screen, access) -> {
            REIRuntime.getInstance().getOverlay(false, true);
            if (class_310.method_1551().field_1755 == screen) {
                OverlaySearchField searchField;
                if (REIRuntime.getInstance().getPreviousScreen() != screen && (searchField = REIRuntimeImpl.getSearchField()) != null) {
                    searchField.method_25365(false);
                }
                REIRuntimeImpl.getInstance().setPreviousScreen(screen);
                ((ScreenRegistryImpl)ScreenRegistry.getInstance()).getLastRendererProvider(screen);
            }
            if (ConfigObject.getInstance().doesDisableRecipeBook() && screen instanceof class_465) {
                access.getRenderables().removeIf(widget -> {
                    if (!(widget instanceof class_344)) return false;
                    class_344 button = (class_344)widget;
                    if (!button.field_45356.comp_1604().equals((Object)recipeButtonTex)) return false;
                    return true;
                });
                access.getNarratables().removeIf(widget -> {
                    if (!(widget instanceof class_344)) return false;
                    class_344 button = (class_344)widget;
                    if (!button.field_45356.comp_1604().equals((Object)recipeButtonTex)) return false;
                    return true;
                });
                screen.method_25396().removeIf(widget -> {
                    if (!(widget instanceof class_344)) return false;
                    class_344 button = (class_344)widget;
                    if (!button.field_45356.comp_1604().equals((Object)recipeButtonTex)) return false;
                    return true;
                });
            }
        });
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = true;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().method_25402(mouseX, mouseY, button)) {
                if (button == 0) {
                    screen.method_25398(true);
                }
                RoughlyEnoughItemsCoreClient.resetFocused(screen);
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = false;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().method_25406(mouseX, mouseY, button) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((minecraftClient, screen, mouseX, mouseY, amountX, amountY) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().method_25401(mouseX, mouseY, amountX, amountY) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.CHAR_TYPED_PRE.register((minecraftClient, screen, character, keyCode) -> {
            class_364 focused;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            if (!REIRuntimeImpl.getSearchField().method_25370() && (focused = screen.method_25399()) != null) {
                class_342 editBox;
                if (focused instanceof class_342 && (editBox = (class_342)focused).method_25370()) {
                    return EventResult.pass();
                }
                if (focused instanceof class_507) {
                    class_507 book = (class_507)focused;
                    if (book.field_3089 != null && book.field_3089.method_25370()) {
                        return EventResult.pass();
                    }
                }
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().method_25400(character, keyCode) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register((minecraftClient, screen, mouseX1, mouseY1, button, mouseX2, mouseY2) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().method_25403(mouseX1, mouseY1, button, mouseX2, mouseY2) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.KEY_PRESSED_PRE.register((minecraftClient, screen, i, i1, i2) -> {
            class_364 focused;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            if (screen instanceof class_465 && ConfigObject.getInstance().doesDisableRecipeBook() && ConfigObject.getInstance().doesFixTabCloseContainer() && i == 258 && minecraftClient.field_1690.field_1822.method_1417(i, i1)) {
                minecraftClient.field_1724.method_7346();
                return EventResult.interruptFalse();
            }
            if (!REIRuntimeImpl.getSearchField().method_25370() && (focused = screen.method_25399()) != null) {
                class_342 editBox;
                if (focused instanceof class_342 && (editBox = (class_342)focused).method_25370()) {
                    return EventResult.pass();
                }
                if (focused instanceof class_507) {
                    class_507 book = (class_507)focused;
                    if (book.field_3089 != null && book.field_3089.method_25370()) {
                        return EventResult.pass();
                    }
                }
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().method_25404(i, i1, i2) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.KEY_RELEASED_PRE.register((minecraftClient, screen, i, i1, i2) -> {
            class_364 focused;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || screen instanceof DisplayScreen) {
                return EventResult.pass();
            }
            if (!REIRuntimeImpl.getSearchField().method_25370() && (focused = screen.method_25399()) != null) {
                class_342 editBox;
                if (focused instanceof class_342 && (editBox = (class_342)focused).method_25370()) {
                    return EventResult.pass();
                }
                if (focused instanceof class_507) {
                    class_507 book = (class_507)focused;
                    if (book.field_3089 != null && book.field_3089.method_25370()) {
                        return EventResult.pass();
                    }
                }
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().method_16803(i, i1, i2) && RoughlyEnoughItemsCoreClient.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    public static boolean resetFocused(class_437 screen) {
        if (screen.method_25399() instanceof ScreenOverlay || screen.method_25399() == screen) {
            screen.method_25395(null);
        }
        return true;
    }

    @ApiStatus.Internal
    public static void reloadPlugins(MutableLong lastReload, @Nullable ReloadStage start) {
        RoughlyEnoughItemsCoreClient.reloadPlugins(lastReload, start, null);
    }

    @ApiStatus.Internal
    public static void reloadPlugins(MutableLong lastReload, @Nullable ReloadStage start, @Nullable class_5455 registryAccess) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        if (lastReload != null) {
            if (lastReload.getValue() > 0L && System.currentTimeMillis() - lastReload.getValue() <= 1000L) {
                InternalLogger.getInstance().warn("Suppressing Reload Plugins of stage " + String.valueOf((Object)start));
                return;
            }
            lastReload.setValue(System.currentTimeMillis());
        }
        ReloadManagerImpl.reloadPlugins(start, () -> InstanceHelper.connectionFromClient() == null);
    }
}

