/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class ItemEntryDefinition
implements EntryDefinition<class_1799>,
EntrySerializer<class_1799> {
    @Environment(value=EnvType.CLIENT)
    private EntryRenderer<class_1799> renderer;
    private static final ReferenceSet<class_1792> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<class_1799> getValueType() {
        return class_1799.class;
    }

    @Override
    public EntryType<class_1799> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public EntryRenderer<class_1799> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public class_2960 getIdentifier(EntryStack<class_1799> entry, class_1799 value) {
        return class_7923.field_41178.method_10221((Object)value.method_7909());
    }

    @Override
    public boolean isEmpty(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7960();
    }

    @Override
    public class_1799 copy(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    @Override
    public class_1799 normalize(EntryStack<class_1799> entry, class_1799 value) {
        class_1799 copy = value.method_7972();
        copy.method_7939(1);
        return copy;
    }

    @Override
    public class_1799 wildcard(EntryStack<class_1799> entry, class_1799 value) {
        return new class_1799((class_1935)value.method_7909(), 1);
    }

    @Override
    @Nullable
    public class_1799 cheatsAs(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    @Override
    @Nullable
    public class_1799 add(class_1799 o1, class_1799 o2) {
        return ItemStackHooks.copyWithCount((class_1799)o1, (int)(o1.method_7947() + o2.method_7947()));
    }

    @Override
    public long hash(EntryStack<class_1799> entry, class_1799 value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.method_7909());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(class_1799 o1, class_1799 o2, ComparisonContext context) {
        if (o1.method_7909() != o2.method_7909()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<class_1799> getSerializer() {
        return this;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public Codec<class_1799> codec() {
        return class_1799.field_24671;
    }

    @Override
    public class_9139<class_9129, class_1799> streamCodec() {
        return class_1799.field_49268;
    }

    @Override
    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value) {
        return this.asFormattedText(entry, value, TooltipContext.of(class_1792.class_9635.field_51353));
    }

    @Override
    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7964();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        try {
            return class_2561.method_43470((String)class_1074.method_4662((String)("item." + class_7923.field_41178.method_10221((Object)value.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return class_2561.method_43470((String)"ERROR");
        }
    }

    @Override
    public Stream<? extends class_6862<?>> getTagsFor(EntryStack<class_1799> entry, class_1799 value) {
        Stream tags = value.method_40133();
        class_1792 class_17922 = value.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            tags = Stream.concat(tags, blockItem.method_7711().method_40142().method_40228());
        }
        return tags;
    }

    @Environment(value=EnvType.CLIENT)
    private List<class_2561> tryGetItemStackToolTip(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7950(context.vanillaContext(), (class_1657)class_310.method_1551().field_1724, context.getFlag());
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        return Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText(entry, value, context)});
    }

    @Override
    public void fillCrashReport(class_128 report, class_129 category, EntryStack<class_1799> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        class_1799 stack = entry.getValue();
        category.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
        category.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
        category.method_577("Item Components", () -> class_9326.field_49589.encodeStart((DynamicOps)BasicDisplay.registryAccess().method_57093((DynamicOps)class_2509.field_11560), (Object)stack.method_57380()).result().map(class_2520::toString).orElse("Error"));
        category.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ItemEntryRenderer
    implements BatchedEntryRenderer<class_1799, class_10444> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public class_10444 getExtraData(EntryStack<class_1799> entry) {
            class_310 minecraft = class_310.method_1551();
            class_10444 renderState = new class_10444();
            minecraft.method_65386().method_65598(renderState, entry.getValue(), class_811.field_4317, false, (class_1937)minecraft.field_1687, (class_1309)minecraft.field_1724, 0);
            return renderState;
        }

        @Override
        public void render(EntryStack<class_1799> entry, class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                class_1799 value = entry.getValue();
                class_10444 renderState = this.getExtraData(entry);
                this.setupGL(entry, renderState);
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)bounds.getCenterX(), (float)bounds.getCenterY(), 0.0f);
                graphics.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                graphics.method_51448().method_22905((float)bounds.getWidth(), (float)bounds.getHeight(), (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f);
                class_4597.class_4598 immediate = graphics.field_44658;
                renderState.method_65604(graphics.method_51448(), (class_4597)immediate, 0xF000F0, class_4608.field_21444);
                immediate.method_22993();
                graphics.method_51448().method_22909();
                Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
                modelViewStack.pushMatrix();
                modelViewStack.mul((Matrix4fc)graphics.method_51448().method_23760().method_23761());
                modelViewStack.translate((float)bounds.x, (float)bounds.y, 0.0f);
                modelViewStack.scale((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
                graphics.method_64039(source -> {
                    if (source instanceof class_4597.class_4598) {
                        class_4597.class_4598 multiBufferSource = (class_4597.class_4598)source;
                        this.renderOverlay(new class_332(class_310.method_1551(), multiBufferSource), entry, bounds);
                    }
                });
                modelViewStack.popMatrix();
                this.endGL(entry, renderState);
            }
        }

        @Override
        public int getBatchIdentifier(EntryStack<class_1799> entry, Rectangle bounds, class_10444 renderState) {
            return 1738923 + (renderState.method_65608() ? 1 : 0);
        }

        @Override
        public void startBatch(EntryStack<class_1799> entry, class_10444 renderState, class_332 graphics, float delta) {
            this.setupGL(entry, renderState);
        }

        public void setupGL(EntryStack<class_1799> entry, class_10444 renderState) {
            class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean sideLit = renderState.method_65608();
            if (!sideLit) {
                class_308.method_24210();
            }
        }

        @Override
        public void renderBase(EntryStack<class_1799> entry, class_10444 renderState, class_332 graphics, class_4597.class_4598 immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                class_1799 value = entry.getValue();
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)bounds.getCenterX(), (float)bounds.getCenterY(), 0.0f);
                graphics.method_51448().method_22905((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f);
                renderState.method_65604(graphics.method_51448(), (class_4597)immediate, 0xF000F0, class_4608.field_21444);
                graphics.method_51448().method_22909();
            }
        }

        @Override
        public void afterBase(EntryStack<class_1799> entry, class_10444 renderState, class_332 graphics, float delta) {
            this.endGL(entry, renderState);
        }

        @Override
        public void renderOverlay(EntryStack<class_1799> entry, class_10444 renderState, class_332 graphics, class_4597.class_4598 immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.mul((Matrix4fc)graphics.method_51448().method_23760().method_23761());
            modelViewStack.translate((float)bounds.x, (float)bounds.y, 0.0f);
            modelViewStack.scale((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            graphics.method_64039(source -> {
                if (source instanceof class_4597.class_4598) {
                    class_4597.class_4598 multiBufferSource = (class_4597.class_4598)source;
                    this.renderOverlay(new class_332(class_310.method_1551(), multiBufferSource), entry, bounds);
                }
            });
            modelViewStack.popMatrix();
        }

        public void renderOverlay(class_332 graphics, EntryStack<class_1799> entry, Rectangle bounds) {
            if (!entry.isEmpty()) {
                graphics.method_51432(class_310.method_1551().field_1772, entry.getValue(), 0, 0, null);
            }
        }

        @Override
        public void endBatch(EntryStack<class_1799> entry, class_10444 renderState, class_332 graphics, float delta) {
        }

        public void endGL(EntryStack<class_1799> entry, class_10444 renderState) {
            RenderSystem.enableDepthTest();
            boolean sideLit = renderState.method_65608();
            if (!sideLit) {
                class_308.method_24211();
            }
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<class_1799> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create(new class_2561[0]);
            Optional component = entry.getValue().method_32347();
            List<class_2561> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(tooltip::add);
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip.withTooltipStyle((class_2960)entry.getValue().method_57824(class_9334.field_54198));
        }
    }
}

