/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.SmithingDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_8057;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay
implements SmithingDisplay {
    public static final DisplaySerializer<DefaultSmithingDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)SmithingDisplay.SmithingRecipeType.CODEC.optionalFieldOf("type").forGetter(d -> d.type), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, DefaultSmithingDisplay::new)), class_9139.method_56905((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getOutputEntries, (class_9139)class_9135.method_56382(SmithingDisplay.SmithingRecipeType.STREAM_CODEC), d -> d.type, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), BasicDisplay::getDisplayLocation, DefaultSmithingDisplay::new));
    private final Optional<SmithingDisplay.SmithingRecipeType> type;

    @ApiStatus.Experimental
    public static DefaultSmithingDisplay ofTransforming(class_8786<class_8060> recipe) {
        return new DefaultSmithingDisplay(List.of(((class_8060)recipe.comp_1933()).method_64722().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), ((class_8060)recipe.comp_1933()).method_64723().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), ((class_8060)recipe.comp_1933()).method_64724().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty())), List.of(EntryIngredients.of(((class_8060)recipe.comp_1933()).field_42033)), Optional.of(SmithingDisplay.SmithingRecipeType.TRANSFORM), Optional.of(recipe.comp_1932().method_29177()));
    }

    public static List<DefaultSmithingDisplay> fromTrimming(class_8786<class_8062> recipe) {
        class_5455 registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (class_6880 templateItem : ((class_8062)recipe.comp_1933()).method_64722().map(class_1856::method_8105).orElse(Stream.of(new class_6880[0]))::iterator) {
            class_6880.class_6883 trimPattern = DefaultSmithingDisplay.getPatternFromTemplate((class_7225.class_7874)registryAccess, (class_6880<class_1792>)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (class_6880 additionStack : ((class_8062)recipe.comp_1933()).method_64724().map(class_1856::method_8105).orElse(Stream.of(new class_6880[0]))::iterator) {
                class_6880.class_6883 trimMaterial = DefaultSmithingDisplay.getMaterialFromIngredient((class_7225.class_7874)registryAccess, (class_6880<class_1792>)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                EntryIngredient baseIngredient = ((class_8062)recipe.comp_1933()).method_64723().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty());
                EntryIngredient templateOutput = baseIngredient.isEmpty() ? EntryIngredient.empty() : DefaultSmithingDisplay.getTrimmingOutput(registryAccess, EntryStacks.ofItemHolder((class_6880<? extends class_1935>)templateItem), (EntryStack)baseIngredient.get(0), EntryStacks.ofItemHolder((class_6880<? extends class_1935>)additionStack));
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.ofItemHolder((class_6880<? extends class_1935>)templateItem), baseIngredient, EntryIngredients.ofItemHolder((class_6880<? extends class_1935>)additionStack)), List.of(templateOutput), Optional.of(SmithingDisplay.SmithingRecipeType.TRIM), Optional.of(recipe.comp_1932().method_29177())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location) {
        this(inputs, outputs, Optional.empty(), location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<SmithingDisplay.SmithingRecipeType> type, Optional<class_2960> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    @Override
    @Nullable
    public SmithingDisplay.SmithingRecipeType type() {
        return this.type.orElse(null);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(class_5455 registryAccess, EntryStack<?> template, EntryStack<?> base, EntryStack<?> addition) {
        if (template.getType() != VanillaEntryTypes.ITEM || base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        class_1799 templateItem = (class_1799)template.castValue();
        class_1799 baseItem = (class_1799)base.castValue();
        class_1799 additionItem = (class_1799)addition.castValue();
        class_6880.class_6883 trimPattern = class_8057.method_48448((class_7225.class_7874)registryAccess, (class_1799)templateItem).orElse(null);
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        class_6880.class_6883 trimMaterial = class_8055.method_48440((class_7225.class_7874)registryAccess, (class_1799)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        class_8053 armorTrim = new class_8053((class_6880)trimMaterial, (class_6880)trimPattern);
        class_8053 trim = (class_8053)baseItem.method_57824(class_9334.field_49607);
        if (trim != null && trim.method_48427((class_6880)trimPattern, (class_6880)trimMaterial)) {
            return EntryIngredient.empty();
        }
        class_1799 newItem = baseItem.method_46651(1);
        newItem.method_57379(class_9334.field_49607, (Object)armorTrim);
        return EntryIngredients.of(newItem);
    }

    private static Optional<class_6880.class_6883<class_8056>> getPatternFromTemplate(class_7225.class_7874 provider, class_6880<class_1792> item) {
        return provider.method_46762(class_7924.field_42082).method_42017().filter(reference -> item == ((class_8056)reference.comp_349()).comp_1214()).findFirst();
    }

    private static Optional<class_6880.class_6883<class_8054>> getMaterialFromIngredient(class_7225.class_7874 provider, class_6880<class_1792> item) {
        return provider.method_46762(class_7924.field_42083).method_42017().filter(reference -> item == ((class_8054)reference.comp_349()).comp_1209()).findFirst();
    }
}

