/*
 * Decompiled with CFR 0.152.
 */
package space.plague.chattimestamps;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ModInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import space.plague.chattimestamps.config.ModConfig;
import space.plague.chattimestamps.config.ModConfigManager;

public class Main
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"plagueschattimestamps");
    public static final String repl = "\u200b";
    public static final Pattern p = Pattern.compile("(\u00a7[0-9a-fk-or])");
    public static String[] formats;
    public static SimpleDateFormat sdf;

    public void onInitialize() {
        LOGGER.info("[Plague's Chat Timestamps] Loading... ");
        ModConfigManager.initializeConfig();
        Main.SetFormat(ModConfigManager.getConfig().getTimestampFormat());
        LOGGER.info("[Plague's Chat Timestamps] All done!");
    }

    public static ModConfig getConfig() {
        return ModConfigManager.getConfig();
    }

    public static void saveConfig() {
        ModConfigManager.save();
    }

    public static void SetFormat(String timestampFormat) {
        LOGGER.info("[Plague's Chat Timestamps] Setting format: " + timestampFormat + "...");
        String format = timestampFormat;
        format = format.replaceAll("&([0-9a-fk-or])", "\u00a7$1");
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = p.matcher(format);
        while (m.find()) {
            matches.add(m.group());
        }
        formats = matches.toArray(new String[0]);
        sdf = new SimpleDateFormat(format.replaceAll(p.pattern(), repl));
        try {
            sdf.format(System.currentTimeMillis());
        }
        catch (NullPointerException ex) {
            LOGGER.warn("[Plague's Chat Timestamps] Format is null, using default format.");
            Main.SetFormat(new ModConfig().getTimestampFormat());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("[Plague's Chat Timestamps] Format is not parseable, using default format.");
            Main.SetFormat(new ModConfig().getTimestampFormat());
        }
    }

    public static String getFormattedTimestamp() {
        Timestamp tstamp = new Timestamp(System.currentTimeMillis());
        String tformat = sdf.format(tstamp);
        int i = 0;
        while (tformat.contains(repl) && i < formats.length) {
            tformat = tformat.replaceFirst(repl, formats[i++]);
        }
        return tformat;
    }
}

