/*
 * Decompiled with CFR 0.152.
 */
package space.plague.chattimestamps.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import space.plague.chattimestamps.Main;
import space.plague.chattimestamps.config.ModConfig;

public class ModConfigManager {
    private static File configFile;
    private static ModConfig config;
    private static Gson gson;

    private static void prepareConfigFile() {
        if (configFile == null) {
            configFile = new File(FabricLoader.getInstance().getConfigDir().toString(), "plagueschattimestamps.json");
        }
    }

    public static ModConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new ModConfig();
        ModConfigManager.load();
        return config;
    }

    public static void save() {
        ModConfigManager.prepareConfigFile();
        String jsonString = gson.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(configFile);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            Main.LOGGER.warn("[Plague's Chat Timestamps] Couldn't save config file!", (Throwable)e);
        }
    }

    private static void load() {
        ModConfigManager.prepareConfigFile();
        try {
            if (!configFile.exists()) {
                ModConfigManager.save();
            } else {
                BufferedReader br = new BufferedReader(new FileReader(configFile));
                ModConfig parsed = (ModConfig)gson.fromJson((Reader)br, ModConfig.class);
                if (parsed != null) {
                    config = parsed;
                }
            }
        }
        catch (FileNotFoundException e) {
            Main.LOGGER.warn("[Plague's Chat Timestamps] Couldn't load config file!", (Throwable)e);
        }
    }

    public static ModConfig getConfig() {
        if (config == null) {
            config = new ModConfig();
        }
        return config;
    }

    static {
        gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    }
}

